VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "ActiveVB.de"
   ClientHeight    =   630
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   3555
   LinkTopic       =   "Form1"
   ScaleHeight     =   630
   ScaleWidth      =   3555
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton cmdSave 
      Caption         =   "Speichern"
      Enabled         =   0   'False
      Height          =   435
      Left            =   2400
      TabIndex        =   2
      Top             =   120
      Width           =   1035
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Enabled         =   0   'False
      Height          =   435
      Left            =   1260
      TabIndex        =   1
      Top             =   120
      Width           =   1035
   End
   Begin VB.CommandButton cmdRecord 
      Caption         =   "Aufnehmen"
      Height          =   435
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1035
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'//Die blichen Objekte
  Dim objDX As New DirectX8
  Dim objDS As DirectSound8
  Dim objDSBuff As DirectSoundSecondaryBuffer8
  
'//Ein Aufnahmeobjekt und ein Buffer
'//auf den aufgenommen wird
  Dim objDSCap As DirectSoundCapture8
  Dim objDSCapBuff As DirectSoundCaptureBuffer8

Private Sub cmdSave_Click()

  Dim descBuff As DSBUFFERDESC 'beschreibt den Sec.Buffer
  Dim waveFormat As WAVEFORMATEX 'beschreibt die Aufnahme
  Dim curInfo As DSCURSORS

    '///////////////////////////////////////////////////
    '//zuerst mssen wir den Capture- in eine SecondaryBuffer
    '//umwandeln, damit wir ihn speichern knnen
    
        'Informationen ber den CaptureBuffer erhalten
        objDSCapBuff.GetCurrentPosition curInfo
        
        'Deskriptor fr Sec.Buffer erstellen
        With descBuff
          'Die bentigte Gre bestimmen
          .lBufferBytes = curInfo.lWrite + 1
          
          'das Format muss bernommen werden
          objDSCapBuff.GetFormat waveFormat
          .fxFormat = waveFormat
        End With
        
        'anhand dieser Daten den Sec.Buffer erstellen
        Set objDSBuff = objDS.CreateSoundBuffer(descBuff)
        
        'jetzt mssen noch die Daten rberkopiert werden
        Dim bytes() As Integer
        
          ReDim bytes(curInfo.lWrite)
          objDSCapBuff.ReadBuffer 0, UBound(bytes), bytes(0), DSCBLOCK_DEFAULT
          objDSBuff.WriteBuffer 0, UBound(bytes), bytes(0), DSBLOCK_DEFAULT
        
    '///////////////////////////////////////////////////
    
    'Abspeichern
    objDSBuff.SaveToFile App.Path & "\wave.wav"
        
End Sub

Private Sub cmdRecord_Click()

  '//wir starten die Aufnahme
  objDSCapBuff.Start DSCBSTART_DEFAULT
  
  '//Buttons an/ausschalten
  cmdRecord.Enabled = False
  cmdSave.Enabled = False
  cmdStop.Enabled = True

End Sub

Private Sub cmdStop_Click()

  '//Aufnahme beenden
  objDSCapBuff.Stop
  
  '//Buttons an/ausschalten
  cmdRecord.Enabled = True
  cmdSave.Enabled = True
  cmdStop.Enabled = False
  
End Sub

Private Sub Form_Load()

  Dim descCapBuff As DSCBUFFERDESC 'Wie soll unser Buffer aussehen?
  Dim capFormat As WAVEFORMATEX 'Was fr ein Format soll die Wavedatei haben?

    '//Das Aufnahmeobjekt erstellen
    '//wir verwenden das Standardgert (vbNullString)
    Set objDSCap = objDX.DirectSoundCaptureCreate(vbNullString)
    
    '//Das Wiedergabeobjekt erstellen
    Set objDS = objDX.DirectSoundCreate(vbNullString)
    
    '//Format festlegen, in dem wir aufnehmen wollen
    With capFormat
      .nFormatTag = WAVE_FORMAT_PCM
      .nChannels = 1 'wir nehmen in mono auf
      .lSamplesPerSec = 44100
      .nBitsPerSample = 16
      .nBlockAlign = .nChannels * .nBitsPerSample / 8
      .lAvgBytesPerSec = .lSamplesPerSec * .nBlockAlign
      .nSize = 0
    End With
    
    '//Unseren Aufnahmebuffer fr DX "beschreiben"
    With descCapBuff
      .fxFormat = capFormat
      .lBufferBytes = capFormat.lAvgBytesPerSec * 20
      .lFlags = DSCBCAPS_WAVEMAPPED
    End With
    
    '//Den Buffer erstellen, auf den wir aufnehmen knnen
    Set objDSCapBuff = objDSCap.CreateCaptureBuffer(descCapBuff)

End Sub
